/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.ForgeEventFactory;
import xueluoanping.teastory.registry.BlockRegister;
import xueluoanping.teastory.registry.ItemRegister;

public class TeaPlantBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)11);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public TeaPlantBlock(BlockBehaviour.Properties copy) {
        super(copy);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 11;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        float f;
        int i;
        super.m_213897_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1) || !worldIn.m_6042_().f_223549_()) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && i != 8 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.m_188503_((int)(25.0f / (f = TeaPlantBlock.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    protected int getBonemealAgeIncrease(ServerLevel worldIn) {
        return 2;
    }

    protected static float getGrowthChance(Block blockIn, ServerLevel worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant((BlockGetter)worldIn, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile((BlockGetter)worldIn, blockpos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.m_122012_();
        BlockPos blockpos2 = pos.m_122019_();
        BlockPos blockpos3 = pos.m_122024_();
        BlockPos blockpos4 = pos.m_122029_();
        boolean flag = blockIn == worldIn.m_8055_(blockpos3).m_60734_() || blockIn == worldIn.m_8055_(blockpos4).m_60734_();
        boolean bl = flag1 = blockIn == worldIn.m_8055_(blockpos1).m_60734_() || blockIn == worldIn.m_8055_(blockpos2).m_60734_();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.m_8055_(blockpos3.m_122012_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos4.m_122012_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos4.m_122019_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos3.m_122019_()).m_60734_();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.CROP;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.m_5776_()) {
            ItemStack stack = player.m_21120_(handIn);
            if (stack.canPerformAction(ToolActions.SHEARS_CARVE)) {
                switch (this.getAge(state)) {
                    case 8: {
                        worldIn.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(worldIn.m_213780_().m_188503_(3) + 4)));
                        worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ItemRegister.TEA_LEAVES.get(), worldIn.m_213780_().m_188503_(5) + 1)));
                        stack.m_41622_(1, (LivingEntity)player, p_55287_ -> p_55287_.m_21190_(handIn));
                        worldIn.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
                        return InteractionResult.SUCCESS;
                    }
                    case 11: {
                        worldIn.m_46597_(pos, (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(worldIn.m_213780_().m_188503_(3) + 4)));
                        worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)BlockRegister.TEA_SEEDS.get(), worldIn.m_213780_().m_188503_(5) + 1)));
                        worldIn.m_7967_((Entity)new ItemEntity(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ItemRegister.TEA_LEAVES.get(), 1)));
                        stack.m_41622_(1, (LivingEntity)player, p_55287_ -> p_55287_.m_21190_(handIn));
                        worldIn.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42574_));
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60734_() instanceof FarmBlock;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entityIn)) {
            worldIn.m_46961_(pos, true);
        }
        if (entityIn instanceof LivingEntity) {
            entityIn.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)BlockRegister.TEA_SEEDS.get();
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack(this.getBaseSeedId());
    }

    public boolean m_7370_(LevelReader p_256559_, BlockPos p_50898_, BlockState p_50899_, boolean p_50900_) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource p_220879_, BlockPos p_220880_, BlockState state) {
        return !this.isMaxAge(state) && (Integer)state.m_61143_((Property)this.getAgeProperty()) != 8;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        if (!worldIn.m_6042_().f_63858_()) {
            return;
        }
        int i = this.getAge(state);
        if (i == 6) {
            worldIn.m_7731_(pos, this.withAge(9), 2);
            return;
        }
        i += this.getBonemealAgeIncrease(worldIn);
        i = Math.min(i, this.getMaxAge());
        worldIn.m_7731_(pos, this.withAge(i), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AGE}));
    }
}

